/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL]    Script Date: 03/12/2014 10:54:51 ******/
IF EXISTS (SELECT
						 *
					 FROM
						 sys.objects
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL]') AND
						type IN ( N'P', N'PC' ))
	DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL]
GO

/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL]    Script Date: 03/12/2014 10:54:51 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL 1,3,'20090131',2
-- EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL
CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_EXECUTE_ALL] @CD_EMP   INT=1,
																				@QT_MESES INT=1,
																				@DT_INI   DATETIME=NULL
AS
		IF @DT_INI IS NULL
			BEGIN
					SET @DT_INI=DBO.F_ONTEM();
			END

		DECLARE @CD_FILIAL INT
		DECLARE @TIPO_ANALISE_FALTAS INT
		declare @msg varchar(100);
		declare @scmd  varchar(150);

		SET @TIPO_ANALISE_FALTAS=ISNULL((SELECT VALOR AS ORC_PED_CP
											FROM
												PRC_EMP_CONFIG
											WHERE
											CD_EMP   = @CD_EMP AND
											CD_CHAVE = 'TIPO_ANALISE_FALTA_PRODUTO'), 0);

		PRINT 'Processamento do analise diaria para todas as filiais ';
		PRINT 'Tipo analise diaria ' + CASE WHEN @TIPO_ANALISE_FALTAS = 0 THEN 'mes fechado' 
												ELSE '30 dias corrente' END;

		--Calcular a participacao dos produtos nos ultimos 30 dias
		--Quando a falta for do tipo ultimos 30 dias
		IF @TIPO_ANALISE_FALTAS IN ( 1, 2 )
			BEGIN
	
				set @scmd  =( isnull( (select 'TRUNCATE TABLE ' +nome_banco_dados + '.dbo.EST_PROD_CPL_ANALISE_30' from PRC_BANCOS_DADOS
				where tipo_banco_Dados=3), 'Print ''ok'' '));
				exec (@scmd);

				IF @TIPO_ANALISE_FALTAS = 1
					PRINT 'Participacao dos ultimos 30 dias '
					+ CONVERT(VARCHAR(8), GETDATE(), 114) + '...'

				IF @TIPO_ANALISE_FALTAS = 2
					PRINT 'MediaF ' + CONVERT(VARCHAR(8), GETDATE(), 114) + '...'

				EXECUTE P_ANALISE_VENDA_PRODUTOS_FILIAL_30_EXECUTE_ALL 1,1,@DT_INI;
			END	

		DECLARE cfiliaisAnalise CURSOR FAST_FORWARD FOR
			SELECT
				CD_FILIAL
			FROM
				PRC_FILIAL
			WHERE
				NOT CD_FILIAL IN (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO) AND
				sts_filial = 0; --RETIRA OS DEPOSITOS PARA RODAR NA ROTINA DE DEPOSITO

		OPEN cfiliaisAnalise
		FETCH NEXT FROM cfiliaisAnalise INTO @CD_FILIAL
		WHILE @@FETCH_STATUS = 0
			BEGIN
					
					SET @msg = ' ****** Analise Diaria ******** ' + convert(varchar, getdate(),108);

					PRINT '  Analise filial '
								+ CONVERT(VARCHAR(5), @CD_FILIAL) + ' ('
								+ CONVERT(VARCHAR(8), GETDATE(), 114) + ')..'
					Print '  Tipo Analise ' + CONVERT(VARCHAR,@TIPO_ANALISE_FALTAS);
					Print '  Qtde meses ' + CONVERT(VARCHAR,@QT_MESES); 
					Print '  DataIni ' + CONVERT(VARCHAR,@DT_INI,112);
					Raiserror (@msg, 0, 1) with nowait;

					IF @TIPO_ANALISE_FALTAS = 0
						BEGIN
								EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL
									1,
									@QT_MESES,
									@DT_INI,
									@CD_FILIAL with recompile;
						END

					IF @TIPO_ANALISE_FALTAS IN ( 1, 2 )
						BEGIN
										 
								EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_30
									1,
									@QT_MESES,
									@DT_INI,
									@CD_FILIAL with recompile;
						END

					FETCH NEXT FROM cfiliaisAnalise INTO @CD_FILIAL
			END

		CLOSE cfiliaisAnalise
		DEALLOCATE cfiliaisAnalise
		
		PRINT 'Concluido.'
GO 
